	function [N,new_omega_p,new_omega_s,new_A_p,new_A_s] = ...
	ClassicIIR_LP_allpara(omega_p, omega_s, A_p, A_s)
	% Given
	% 1) omega_p and omega_s, the passband and stopband edges as fractions of 
	%    pi or half the sampling frequency, and 
	% 2) A_p and A_s, the passband variation and stopband attenuation in dB,
	% [N,new_omega_p,new_omega_s,new_A_p,new_A_s] =
	%                        ClassicIIR_LP_allpara(omega_p, omega_s, A_p, A_s)
	% returns, first, the required filter orders such that 
	% * N(1) is the minimum order for the Butterworth filter,
	% * N(2) is the minimum order for the Chebyshev or Chebyshev Type I filter,
	% * N(3) is the minimum order for the inverse Chebyshev or Chebyshev Type 
	%   II filter, and
	% * N(4) is the minimum order for the elliptic or Cauer filter.
	% In practically all cases, the filter with the minimum order exceeds the 
	% given criteria. This additional design margin is delivered in the 
	% following four manners:
	% 1) new_omega_p(k) for k=1, k=2, k=3, and k=4 contain the maximized 
	%    values of the passband edges for the Butterworth, Chebyshev, inverse
	%    Chebyshev, and Cauer filters, respectively,
	% 2) Similarly, the new_omega_s's contain the minimized values of the 
	%    stopband edges,
	% 3) The new_A_p's contain the minimized values of the passband variations,
	%    and
	% 4) The new_A_s's in turn include the maximized values of the stopband 
	%    attenuations.
	% This file has been constructed based on the article
	% S. Darlington, "Simple algorithms for elliptic filters and 
	% generalizations thereof", IEEE Trans. Circuits and Systems, CAS-25, 
	% pp. 975 - 980, Dec. 1978.
	% as well as the lecture notes
	% http://www.cs.tut.fi/~ts/part4.pdf
	% Tapio, 11.9.2018
	% A new reference is coming up soon:
	% T. Saramki, "Simple Formulae for Designing Classical Recursive Digital
	% Filters".
	
	% Minimun filter orders in decimals for Butterworth, Chebyshev, inverse 
	% Chebyshev, and Cauer filters.
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	%	Author: 			Tapio Saramaki 2018-09-11
	%	Modified by:	
	%	Copyright:			by authors - not released for commercial use
	%	Version:			1	 
	%	Known bugs:	 
	%	Report bugs to:		tapio.saramaki@tut.fi
	
	a0=sqrt(tan(pi*omega_s/2)/tan(pi*omega_p/2));  
	a1=a0^2+sqrt(a0^4-1);
	a2=a1^2+sqrt(a1^4-1);
	a3=a2^2+sqrt(a2^4-1);
	a4=a3^2+sqrt(a3^4-1);
	J0=sqrt(sqrt((10^(A_s/10)-1))/sqrt((10^(A_p/10)-1)));
	J1=J0^2+sqrt(J0^4-1);
	J2=J1^2+sqrt(J1^4-1);
	J3=J2^2+sqrt(J2^4-1);
	J4=J3^2+sqrt(J3^4-1);
	N(1)=log10(J0)/log10(a0);
	N(2)=log10(J1)/log10(a1);
	% The orders for the the Chebyshev and inverse Chebyshev filters are the 
	% same.
	N(3)=N(2);
	N(4)=log10(2*J4)/log10(2*a4);
	% Minimun integer-valued filter orders that are larger than or equal to 
	% their decimal counterparts.
	N=ceil(N);
	% Minimized values of omega_s, indicated by new_omega_s, and maximized 
	% values of omega_p, indicated by new_omega_p.
	new_omega_s(1)=2*atan(J0^(2/N(1))*tan(pi*omega_p/2))/pi;
	new_omega_p(1)=2*atan(tan(pi*omega_s/2)/(J0^(2/N(1))))/pi;
	new_omega_s(2)=2*atan(.5*(J1^(1/N(2))+1/(J1^(1/N(2))))*tan(pi*omega_p/2))/pi;
	new_omega_p(2)=...
	2*atan(tan(pi*omega_s/2)/(.5*(J1^(1/N(2))+1/(J1^(1/N(2))))))/pi;
	b4=(J4/(2^(N(4)-1)))^(1/N(4));
	b3=sqrt((b4+1/b4)/2);
	b2=sqrt((b3+1/b3)/2);
	b1=sqrt((b2+1/b2)/2);
	b0=sqrt((b1+1/b1)/2);
	new_omega_s(4)=2*atan(b0^2*tan(pi*omega_p/2))/pi;
	new_omega_p(4)=2*atan(tan(pi*omega_s/2)/b0^2)/pi;
	% The values for the Chebyshev and inverse Chebyshev filters are the same.
	new_omega_s(3)=new_omega_s(2);
	new_omega_p(3)=new_omega_p(2);
	% Maximized values of A_s, indicated by new_A_s, and minimized values of 
	% A_p, indicated by new_A_p.
	new_A_s(1)=10*log10(1+(10^(A_p/10)-1)*a0^(4*N(1)));
	new_A_p(1)=10*log10(1+(10^(A_s/10)-1)/a0^(4*N(1)));
	new_A_s(2)=10*log10(1+(10^(A_p/10)-1)*((a1^N(2)+1/a1^N(2))/2)^2);
	new_A_p(2)=10*log10(1+(10^(A_s/10)-1)/((a1^N(2)+1/a1^N(2))/2)^2);
	c4=2^(N(4)-1)*a4^(N(4));
	c3=sqrt((c4+1/c4)/2);
	c2=sqrt((c3+1/c3)/2);
	c1=sqrt((c2+1/c2)/2);
	c0=sqrt((c1+1/c1)/2);
	new_A_s(4)=10*log10(1+(10^(A_p/10)-1)*c0^4);
	new_A_p(4)=10*log10(1+(10^(A_s/10)-1)/c0^4);
	% The values for the Chebyshev and inverse Chebyshev filters are the same.
	new_A_s(3)=new_A_s(2);
	new_A_p(3)=new_A_p(2);
